<?php 
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

function ecobin_admin_css() {
	wp_enqueue_style( 'theme-default-font-admin', ecobin_slug_fonts_url(), array(), null );
	wp_enqueue_style( 'ecobin-admin', ECOBIN_THEME_URL . '/assets/css/admin.css', array(), ECOBIN_THEME_VERSION );	
	
	$documentation_link = apply_filters('ecobin_documentation_link', true);

    if ($documentation_link) {
		wp_enqueue_script( 'ecobin-admin-js', ECOBIN_THEME_URL . '/assets/js/admin.js', array( 'jquery' ), ECOBIN_THEME_VERSION, true );    
    }
	
}

// Hook the custom_admin_css function to the admin_enqueue_scripts action.
add_action('admin_enqueue_scripts', 'ecobin_admin_css', 11);

add_action('admin_menu', 'ecobin_custom_appearance_submenu');

function ecobin_custom_appearance_submenu() {
	
    $documentation_link = apply_filters('ecobin_documentation_link', true);

    if (!$documentation_link) {
        return;
    }
	
    add_submenu_page(
        'themes.php', 
        __( 'Documentation', 'ecobin' ), 
        __( 'Documentation', 'ecobin' ), 
        'manage_options', 
        'custom_documentation_link', 
        '__return_null' 
    );
}