<?php 
/*
Plugin Name:  Ecobin Theme Addons
Plugin URI:   https://awaikenthemes.com
Description:  This plugin is intended for use with the ecobin theme.
Version:      1.0.0
Author:       Awaiken Technology
Author URI:   https://awaiken.com
License:      GNU General Public License v3 or later.
License URI:  https://www.gnu.org/licenses/gpl-3.0.html
Text Domain:  ecobin-theme-addons
Domain Path:  /languages
*/

define( 'ECOBIN_ADDONS_URL', plugins_url( '/', __FILE__ ) );
define( 'ECOBIN_ADDONS_PATH', plugin_dir_path( __FILE__ ) );
define( 'ECOBIN_PLUGIN_VERSION', '1.0.0' );


// Load translation.
add_action( 'init', 'ecobin_i18n' );

/**
 * Load the plugin text domain for translation.
 *
 * @since    1.0.0
 */
function ecobin_i18n() {
	load_plugin_textdomain( 'ecobin-theme-addons' );
}

/* Allow SVG upload */
add_filter( 'wp_check_filetype_and_ext', function( $data, $file, $filename, $mimes ) {

  $filetype = wp_check_filetype( $filename, $mimes );

  return [
      'ext' => $filetype['ext'],
      'type' => $filetype['type'],
      'proper_filename' => $data['proper_filename']
  ];

}, 10, 4 );

function ecobin_allow_svg_upload( $mimes ) {
  $mimes['svg'] = 'image/svg+xml';
  $mimes['svgz'] = 'image/svg+xml';
  return $mimes;
}
add_filter( 'upload_mimes', 'ecobin_allow_svg_upload' );

require ECOBIN_ADDONS_PATH . 'includes/secondary-image.php';

/*
* Project CPT
*/
if(!class_exists('Awaiken_Project')) { 
	class Awaiken_Project {

		const PROJECT_CPT_SLUG = 'awaiken-project';
		const PROJECT_CATEGORY_SLUG = 'awaiken-project-category';

		public function register_data() {

			$labels = [
				'name' => esc_html_x( 'Projects', 'Projects', 'ecobin-theme-addons' ),
				'singular_name' => esc_html_x( 'Project', 'Project', 'ecobin-theme-addons' ),
				'menu_name' => esc_html_x( 'Projects', 'Projects', 'ecobin-theme-addons' ),
				'name_admin_bar' => esc_html__( 'Project Item', 'ecobin-theme-addons' ),
				'archives' => esc_html__( 'Project Item Archives', 'ecobin-theme-addons' ),
				'parent_item_colon' => esc_html__( 'Parent Item:', 'ecobin-theme-addons' ),
				'all_items' => esc_html__( 'All Items', 'ecobin-theme-addons' ),
				'add_new_item' => esc_html__( 'Add New Project', 'ecobin-theme-addons' ),
				'add_new' => esc_html__( 'Add New', 'ecobin-theme-addons' ),
				'new_item' => esc_html__( 'New Project', 'ecobin-theme-addons' ),
				'edit_item' => esc_html__( 'Edit Project', 'ecobin-theme-addons' ),
				'update_item' => esc_html__( 'Update Project', 'ecobin-theme-addons' ),
				'view_item' => esc_html__( 'View Project', 'ecobin-theme-addons' ),
				'search_items' => esc_html__( 'Search Projects', 'ecobin-theme-addons' ),
				'not_found' => esc_html__( 'Not found', 'ecobin-theme-addons' ),
				'not_found_in_trash' => esc_html__( 'Not found in Trash', 'ecobin-theme-addons' ),
				'featured_image' => esc_html__( 'Featured Image', 'ecobin-theme-addons' ),
				'set_featured_image' => esc_html__( 'Set featured image', 'ecobin-theme-addons' ),
				'remove_featured_image' => esc_html__( 'Remove featured image', 'ecobin-theme-addons' ),
				'use_featured_image' => esc_html__( 'Use as featured image', 'ecobin-theme-addons' ),
				'insert_into_item' => esc_html__( 'Insert into Project', 'ecobin-theme-addons' ),
				'uploaded_to_this_item' => esc_html__( 'Uploaded to this Project', 'ecobin-theme-addons' ),
				'items_list' => esc_html__( 'Items list', 'ecobin-theme-addons' ),
				'items_list_navigation' => esc_html__( 'Items list navigation', 'ecobin-theme-addons' ),
				'filter_items_list' => esc_html__( 'Filter items list', 'ecobin-theme-addons' ),
			];

			$project_slug = apply_filters( 'awaiken_project_slug', 'projects' );

			$rewrite = [
				'slug' => $project_slug,
				'with_front' => false,
			];

			$args = [
				'labels' => $labels,
				'public' => true,
				'menu_position' => 25,
				'menu_icon' => 'dashicons-format-image',
				'capability_type' => 'post',
				'supports' => [ 'title', 'editor', 'thumbnail', 'author', 'excerpt', 'comments', 'revisions', 'page-attributes', 'custom-fields', 'elementor' ],
				'has_archive' => true,
				'rewrite' => $rewrite,
			];

			register_post_type( self::PROJECT_CPT_SLUG, $args );

			// Categories
			$project_category_slug = apply_filters( 'awaiken_project_category_slug', 'project-category' );

			$rewrite = [
				'slug' => $project_category_slug,
				'with_front' => false,
			];

			$args = [
				'hierarchical' => true,
				'show_ui' => true,
				'show_in_nav_menus' => false,
				'show_admin_column' => true,
				'labels' => $labels,
				'rewrite' => $rewrite,
				'public' => true,
				'labels' => [
					'name' => esc_html_x( 'Categories', 'Project', 'ecobin-theme-addons' ),
					'singular_name' => esc_html_x( 'Category', 'Project', 'ecobin-theme-addons' ),
					'all_items' => esc_html_x( 'All Categories', 'Project', 'ecobin-theme-addons' ),
				],
			];
			register_taxonomy( self::PROJECT_CATEGORY_SLUG, self::PROJECT_CPT_SLUG, $args );
		}

		public function __construct() {
			add_action( 'init', [ $this, 'register_data' ], 1 );
		}
	}
	/**
	 * initialize 
	 */
	$Awaiken_Project = new Awaiken_Project();
}