<?php 
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
* Set our Customizer default options
*/
if ( ! function_exists( 'awaiken_generate_defaults' ) ) {
	function awaiken_generate_defaults() {
		global $ECOBIN_STORAGE;

		return apply_filters( 'awaiken_customizer_defaults', $ECOBIN_STORAGE );
	}
}


/**
 * Customizer Setup and Custom Controls
 *
 */

/**
 * Adds the individual sections, settings, and controls to the theme customizer
 */
class awaiken_initialise_customizer_settings {
	// Get our default values
	private $defaults;

	public function __construct() {
		// Get our Customizer defaults
		$this->defaults = awaiken_generate_defaults();


		// Register sections
		add_action( 'customize_register', array( $this, 'awaiken_add_customizer_sections' ) );
		
		// Register general control
		add_action( 'customize_register', array( $this, 'awaiken_register_general_options_controls' ) );
		
		// Register project control
		add_action( 'customize_register', array( $this, 'awaiken_register_project_options_controls' ) );

		// Register blog control
		add_action( 'customize_register', array( $this, 'awaiken_register_blog_options_controls' ) );

		// Register 404 control
		add_action( 'customize_register', array( $this, 'awaiken_register_404_options_controls' ) );
		
		// Register footer control
		add_action( 'customize_register', array( $this, 'awaiken_register_footer_options_controls' ) );
		
	}


	/**
	 * Register the Customizer sections
	 */
	public function awaiken_add_customizer_sections( $wp_customize ) {
		
		// Add section general options
		$wp_customize->add_section( 'general_options' , array(
			'title'      => __( 'General Options', 'ecobin' ),
		) );
		
		// Add section project options
		$wp_customize->add_section( 'project_options' , array(
			'title'      => __( 'Project Options', 'ecobin' ),
		) );
		
		// Add section blog options
		$wp_customize->add_section( 'blog_options' , array(
			'title'      => __( 'Blog Options', 'ecobin' ),
		) );

		// Add section 404 options
		$wp_customize->add_section( '404_options' , array(
			'title'      => __( '404 Options', 'ecobin' ),
		) );
		
		// Add section footer options
		$wp_customize->add_section( 'footer_options' , array(
			'title'      => __( 'Footer Options', 'ecobin' ),
		) );
		
	}
	
	/**
	 * Register general option controls
	 */

	public function awaiken_register_general_options_controls( $wp_customize ) {  
		
		$section	=	'general_options';
		
		// Preloader
		$wp_customize->add_setting( 'show_preloader',
			array(
				'default' => $this->defaults['show_preloader'],
				'transport' => 'refresh',
				'sanitize_callback' => 'skyrocket_switch_sanitization'
			)
		);
		
		$wp_customize->add_control( new Skyrocket_Toggle_Switch_Custom_control( $wp_customize, 'show_preloader',
			array(
				'label' => __( 'Preloader', 'ecobin' ),
				'description' => esc_html__( 'Display preloader while the page is loading.', 'ecobin' ),
				'section' => $section
			)
		) );
		
		// Magic Cursor
		$wp_customize->add_setting( 'magic_cursor',
			array(
				'default' => $this->defaults['magic_cursor'],
				'transport' => 'refresh',
				'sanitize_callback' => 'skyrocket_switch_sanitization'
			)
		);
		$wp_customize->add_control( new Skyrocket_Toggle_Switch_Custom_control( $wp_customize, 'magic_cursor',
			array(
				'label' => __( 'Magic Cursor', 'ecobin' ),
				'description' => esc_html__( 'Show Magic Cursor.', 'ecobin' ),
				'section' => $section
			)
		) );

		// Custom fancy scrollbar
		$wp_customize->add_setting( 'custom_fancy_scrollbar',
			array(
				'default' => $this->defaults['custom_fancy_scrollbar'],
				'transport' => 'refresh',
				'sanitize_callback' => 'skyrocket_switch_sanitization'
			)
		);
		$wp_customize->add_control( new Skyrocket_Toggle_Switch_Custom_control( $wp_customize, 'custom_fancy_scrollbar',
			array(
				'label' => __( 'Custom Fancy Scrollbar', 'ecobin' ),
				'description' => esc_html__( 'Custom fancy scrollbar Disable/Enable.', 'ecobin' ),
				'section' => $section
			)
		) );
		
		// Smooth scrolling
		$wp_customize->add_setting( 'smooth_scrolling',
			array(
				'default' => $this->defaults['smooth_scrolling'],
				'transport' => 'refresh',
				'sanitize_callback' => 'skyrocket_switch_sanitization'
			)
		);
		$wp_customize->add_control( new Skyrocket_Toggle_Switch_Custom_control( $wp_customize, 'smooth_scrolling',
			array(
				'label' => __( 'Smooth Scrolling', 'ecobin' ),
				'description' => esc_html__( 'Smooth Scrolling Disable/Enable', 'ecobin' ),
				'section' => $section
			)
		) );
		
		// heading icon 
		$wp_customize->add_setting( 'show_small_heading_icon',
			array(
				'default' => $this->defaults['show_small_heading_icon'],
				'transport' => 'refresh',
				'sanitize_callback' => 'skyrocket_switch_sanitization'
			)
		);
		
		$wp_customize->add_control( new Skyrocket_Toggle_Switch_Custom_control( $wp_customize, 'show_small_heading_icon',
			array(
				'label' => __( 'Display Small Icon', 'ecobin' ),
				'description' => esc_html__( 'Display small icon before small heading.', 'ecobin' ),
				'section' => $section
			)
		) );
		
		// heading icon
		$wp_customize->add_setting( 'small_heading_icon',
			array(
				'default' => $this->defaults['small_heading_icon'],
				'transport' => 'refresh',
				'sanitize_callback' => 'absint'
			)
		);
		
		$wp_customize->add_control( new WP_Customize_Media_Control( $wp_customize, 'small_heading_icon',
			array(
				'label' => __( 'Small heading icon', 'ecobin' ),
				'description' => esc_html__( 'If you want to change the current icon, select it here.', 'ecobin' ),
				'section' => $section,
				'mime_type' => 'image',
				'button_labels' => array(
					'select' => __( 'Select File', 'ecobin' ),
					'change' => __( 'Change File', 'ecobin' ),
					'default' => __( 'Default', 'ecobin' ),
					'remove' => __( 'Remove', 'ecobin' ),
					'placeholder' => __( 'No file selected', 'ecobin' ),
					'frame_title' => __( 'Select File', 'ecobin' ),
					'frame_button' => __( 'Choose File', 'ecobin' ),
				)
			)
		) );
		
		// Preloader icon
		$wp_customize->add_setting( 'preloader_icon',
			array(
				'default' => $this->defaults['preloader_icon'],
				'transport' => 'refresh',
				'sanitize_callback' => 'absint'
			)
		);
		
		$wp_customize->add_control( new WP_Customize_Media_Control( $wp_customize, 'preloader_icon',
			array(
				'label' => __( 'Preloader icon', 'ecobin' ),
				'description' => esc_html__( 'If you want to change the current loading icon, select it here.', 'ecobin' ),
				'section' => $section,
				'mime_type' => 'image',
				'button_labels' => array(
					'select' => __( 'Select File', 'ecobin' ),
					'change' => __( 'Change File', 'ecobin' ),
					'default' => __( 'Default', 'ecobin' ),
					'remove' => __( 'Remove', 'ecobin' ),
					'placeholder' => __( 'No file selected', 'ecobin' ),
					'frame_title' => __( 'Select File', 'ecobin' ),
					'frame_button' => __( 'Choose File', 'ecobin' ),
				)
			)
		) );
		
		// Header background image
		$wp_customize->add_setting( 'header_background_image',
			array(
				'default' => '',
				'transport' => 'refresh',
				'sanitize_callback' => 'absint'
			)
		);
		
		$wp_customize->add_control( new WP_Customize_Media_Control( $wp_customize, 'header_background_image',
			array(
				'label' => __( 'Header Background Image', 'ecobin' ),
				'description' => esc_html__( 'Header background image is intended for pages that are not created using Elementor.', 'ecobin' ),
				'section' => $section,
				'mime_type' => 'image',
				'button_labels' => array(
					'select' => __( 'Select File', 'ecobin' ),
					'change' => __( 'Change File', 'ecobin' ),
					'default' => __( 'Default', 'ecobin' ),
					'remove' => __( 'Remove', 'ecobin' ),
					'placeholder' => __( 'No file selected', 'ecobin' ),
					'frame_title' => __( 'Select File', 'ecobin' ),
					'frame_button' => __( 'Choose File', 'ecobin' ),
				)
			)
		) );

	}
	
	/**
	 * Register project option controls
	 */
	
	public function awaiken_register_project_options_controls( $wp_customize ) { 
			
		$section	=	'project_options';

		// Project page title 
		$wp_customize->add_setting( 'project_page_title', array(
			'capability' => 'edit_theme_options',
			'sanitize_callback' => 'sanitize_text_field',
		) );

		$wp_customize->add_control( 'project_page_title', array(
			'type' => 'text',
			'section' => $section,
			'label'       => esc_html__( 'Project Page Archive Title', 'ecobin' ),
		) );
		
		// Header background image
		$wp_customize->add_setting( 'project_page_header_background_image',
			array(
				'default' => '',
				'transport' => 'refresh',
				'sanitize_callback' => 'absint'
			)
		);
		
		$wp_customize->add_control( new WP_Customize_Media_Control( $wp_customize, 'project_page_header_background_image',
			array(
				'label' => __( 'Header Background Image', 'ecobin' ),
				'description' => esc_html__( 'Header background image for project archive and single pages that are not created using Elementor.', 'ecobin' ),
				'section' => $section,
				'mime_type' => 'image',
				'button_labels' => array(
					'select' => __( 'Select File', 'ecobin' ),
					'change' => __( 'Change File', 'ecobin' ),
					'default' => __( 'Default', 'ecobin' ),
					'remove' => __( 'Remove', 'ecobin' ),
					'placeholder' => __( 'No file selected', 'ecobin' ),
					'frame_title' => __( 'Select File', 'ecobin' ),
					'frame_button' => __( 'Choose File', 'ecobin' ),
				)
			)
		) );
		
		// Archive page layout
		$wp_customize->add_setting( 'project_archive_page_layout', array(
		  'default' => $this->defaults['project_archive_page_layout'],
		   'sanitize_callback' => 'sanitize_text_field',
		) );
		
		$wp_customize->add_control( 'project_archive_page_layout', array(
			  'label'          => __( 'Project Archive Page Layout', 'ecobin' ),
			  'section' => $section,
			  'settings' => 'project_archive_page_layout',
			  'type' => 'radio',
			  'choices' => array(
				'full-width'   => __( 'Full Width', 'ecobin' ),
				'with-sidebar'  => __( 'With Sidebar', 'ecobin' )
			  ),
		) );
		
		// Archive page single page layout
		$wp_customize->add_setting( 'project_single_page_layout', array(
		  'default' => $this->defaults['project_single_page_layout'],
		   'sanitize_callback' => 'sanitize_text_field',
		) );
		
		$wp_customize->add_control( 'project_single_page_layout', array(
			  'label'          => __( 'Project Single Layout', 'ecobin' ),
			  'description' => esc_html__( 'Works with the Default Template only.', 'ecobin' ),
			  'section' => $section,
			  'settings' => 'project_single_page_layout',
			  'type' => 'radio',
			  'choices' => array(
				'full-width'   => __( 'Full Width', 'ecobin' ),
				'with-sidebar'  => __( 'With Sidebar', 'ecobin' )
			  ),
		) );
		
	}
	
	/**
	 * Register blog option controls
	 */
	
	public function awaiken_register_blog_options_controls( $wp_customize ) { 
			
		$section	=	'blog_options';

		// Blog page title 
		$wp_customize->add_setting( 'blog_page_title', array(
			'capability' => 'edit_theme_options',
			'sanitize_callback' => 'sanitize_text_field',
		) );

		$wp_customize->add_control( 'blog_page_title', array(
			'type' => 'text',
			'section' => $section,
			'label'       => esc_html__( 'Blog Page Title', 'ecobin' ),
		) );
		
		//Header Background Image
		$wp_customize->add_setting( 'blog_page_header_background_image',
			array(
				'default' => '',
				'transport' => 'refresh',
				'sanitize_callback' => 'absint'
			)
		);
		
		$wp_customize->add_control( new WP_Customize_Media_Control( $wp_customize, 'blog_page_header_background_image',
			array(
				'label' => __( 'Header Background Image', 'ecobin' ),
				'description' => esc_html__( 'Header background image for blog archive and single page.', 'ecobin' ),
				'section' => $section,
				'mime_type' => 'image',
				'button_labels' => array(
					'select' => __( 'Select File', 'ecobin' ),
					'change' => __( 'Change File', 'ecobin' ),
					'default' => __( 'Default', 'ecobin' ),
					'remove' => __( 'Remove', 'ecobin' ),
					'placeholder' => __( 'No file selected', 'ecobin' ),
					'frame_title' => __( 'Select File', 'ecobin' ),
					'frame_button' => __( 'Choose File', 'ecobin' ),
				)
			)
		) );
		
		// Archive page layout
		$wp_customize->add_setting( 'archive_page_layout', array(
		  'default' => $this->defaults['archive_page_layout'],
		   'sanitize_callback' => 'sanitize_text_field',
		) );
		
		$wp_customize->add_control( 'archive_page_layout', array(
			  'label'          => __( 'Archive Page Layout', 'ecobin' ),
			  'section' => $section,
			  'settings' => 'archive_page_layout',
			  'type' => 'radio',
			  'choices' => array(
				'full-width'   => __( 'Full Width', 'ecobin' ),
				'with-sidebar'  => __( 'With Sidebar', 'ecobin' )
			  ),
		) );
		
		// Archive page single page layout
		$wp_customize->add_setting( 'blog_single_page_layout', array(
		  'default' => $this->defaults['blog_single_page_layout'],
		   'sanitize_callback' => 'sanitize_text_field',
		) );
		
		$wp_customize->add_control( 'blog_single_page_layout', array(
			  'label'          => __( 'Blog Single Layout', 'ecobin' ),
			  'description' => esc_html__( 'Works with the Default Template only.', 'ecobin' ),
			  'section' => $section,
			  'settings' => 'blog_single_page_layout',
			  'type' => 'radio',
			  'choices' => array(
				'full-width'   => __( 'Full Width', 'ecobin' ),
				'with-sidebar'  => __( 'With Sidebar', 'ecobin' )
			  ),
		) );
		
		// Social Sharing
		$wp_customize->add_setting( 'social_sharing',
			array(
				'default' => $this->defaults['social_sharing'],
				'transport' => 'refresh',
				'sanitize_callback' => 'skyrocket_text_sanitization'
			)
		);
		$wp_customize->add_control( new Skyrocket_Pill_Checkbox_Custom_Control( $wp_customize, 'social_sharing',
			array(
				'label' => __( 'Social Sharing', 'ecobin' ),
				'description' => esc_html__( 'Choose the social network you want to display in the social share box.', 'ecobin' ),
				'section' => $section,
				'input_attrs' => array(
					'sortable' => true,
					'fullwidth' => true,
				),
				'choices' => array(
					'facebook' => esc_attr__( 'Facebook', 'ecobin' ),
					'twitter' => esc_attr__( 'Twitter', 'ecobin' ),
					'whatsapp' => esc_attr__( 'Whatsapp', 'ecobin' ),
					'linkedin' => esc_attr__( 'LinkedIn', 'ecobin' ),
					'reddit' => esc_attr__( 'Reddit', 'ecobin' ),
					'tumblr' => esc_attr__( 'Tumblr', 'ecobin' ),
					'pinterest' => esc_attr__( 'Pinterest', 'ecobin' ),
					'vk' => esc_attr__( 'vk', 'ecobin' ),
					'email' => esc_attr__( 'Email', 'ecobin' ),
					'telegram' => esc_attr__( 'Telegram', 'ecobin' ),
				)
			)
		) );

	}

	/**
	 * Register 404 controls
	 */
	
	 public function awaiken_register_404_options_controls( $wp_customize ) { 
			
		$section	=	'404_options';
		
		// 404 Image
		$wp_customize->add_setting( 'not_found_image',
			array(
				'default' => '',
				'transport' => 'refresh',
				'sanitize_callback' => 'absint'
			)
		);
		
		$wp_customize->add_control( new WP_Customize_Media_Control( $wp_customize, 'not_found_image',
			array(
				'label' => __( '404 Image', 'ecobin' ),
				'section' => $section,
				'mime_type' => 'image',
				'button_labels' => array(
					'select' => __( 'Select File', 'ecobin' ),
					'change' => __( 'Change File', 'ecobin' ),
					'default' => __( 'Default', 'ecobin' ),
					'remove' => __( 'Remove', 'ecobin' ),
					'placeholder' => __( 'No file selected', 'ecobin' ),
					'frame_title' => __( 'Select File', 'ecobin' ),
					'frame_button' => __( 'Choose File', 'ecobin' ),
				)
			)
		) );
		
		// 404 Heading
		$wp_customize->add_setting( 'not_found_heading',
			array(
				'default' => $this->defaults['not_found_heading'],
				'transport' => 'refresh',
				'sanitize_callback' => 'wp_kses_post'
			)
		);
		$wp_customize->add_control( 'not_found_heading',
			array(
				'label' => esc_html__( '404 Heading', 'ecobin' ),
				'section' => $section,
				'type' => 'text',

			)
		);
		
		// 404 text
		$wp_customize->add_setting( 'not_found_text',
			array(
				'default' => $this->defaults['not_found_text'],
				'transport' => 'refresh',
				'sanitize_callback' => 'wp_kses_post'
			)
		);
		$wp_customize->add_control( 'not_found_text',
			array(
				'label' => esc_html__( '404 Text', 'ecobin' ),
				'section' => $section,
				'type' => 'textarea',
			)
		);
	}
	
	/**
	 * Register footer controls
	 */
	
	public function awaiken_register_footer_options_controls( $wp_customize ) { 
		
		$section	=	'footer_options';
		
		//Footer logo
		$wp_customize->add_setting( 'footer_logo',
			array(
				'default' => '',
				'transport' => 'refresh',
				'sanitize_callback' => 'absint'
			)
		);
		
		$wp_customize->add_control( new WP_Customize_Media_Control( $wp_customize, 'footer_logo',
			array(
				'label' => __( 'Footer Logo', 'ecobin' ),
				'section' => $section,
				'mime_type' => 'image',
				'button_labels' => array(
					'select' => __( 'Select File', 'ecobin' ),
					'change' => __( 'Change File', 'ecobin' ),
					'default' => __( 'Default', 'ecobin' ),
					'remove' => __( 'Remove', 'ecobin' ),
					'placeholder' => __( 'No file selected', 'ecobin' ),
					'frame_title' => __( 'Select File', 'ecobin' ),
					'frame_button' => __( 'Choose File', 'ecobin' ),
				)
			)
		) );
		
		// Copyright text
		$wp_customize->add_setting( 'footer_copyright_text',
			array(
				'default' => $this->defaults['footer_copyright_text'],
				'transport' => 'refresh',
				'sanitize_callback' => 'wp_kses_post'
			)
		);
		$wp_customize->add_control( 'footer_copyright_text',
			array(
				'label' => __( 'Copyright Text', 'ecobin' ),
				'section' => $section,
				'type' => 'textarea',
			)
		);
		
		// Social media URLs
		$wp_customize->add_setting( 'social_urls',
			array(
				'default' => $this->defaults['social_urls'],
				'transport' => 'refresh',
				'sanitize_callback' => 'skyrocket_url_sanitization'
			)
		);
		$wp_customize->add_control( new Skyrocket_Sortable_Repeater_Custom_Control( $wp_customize, 'social_urls',
			array(
				'label' => __( 'Social URLs', 'ecobin' ),
				'description' => esc_html__( 'Enter the social profile URLs.', 'ecobin' ),
				'section' => $section,
				'button_labels' => array(
					'add' => __( 'Add Row', 'ecobin' ),
				)
			)
		) );
		
	}
	
}

/**
 * Load all our Customizer Custom Controls
 */
require_once ECOBIN_THEME_DIR . '/inc/customizer/custom-controls.php';

/**
 * Initialise our Customizer settings
 */
$awaiken_settings = new awaiken_initialise_customizer_settings();
