<?php

use Elementor\Widget_Base;

defined('ABSPATH') || exit;


class ecobin_widget_breadcrumb extends Widget_Base {

	public function get_name() {
		return 'ecobin-breadcrumb';
	}


	public function get_title() {
		return __( 'Ecobin - Breadcrumb', 'ecobin' );
	}


	public function get_icon() {
		return ' eicon-chevron-double-right';
	}


	public function get_categories() {
		return array( 'basic' );
	}

	public function get_keywords() {
		return array( 'awaiken', 'breadcrumbs', 'crumbs', 'list' );
	}


    protected function is_dynamic_content(): bool {
        return false;
    }
	
	protected function register_controls() {
		$this->start_controls_section(
			'breadcrumbs_section',
			[
				'label' => __( 'Settings', 'ecobin' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'breadcrumbs_control',
			[
				'label'   => __( 'This does nothing', 'ecobin' ),
				'type'    => \Elementor\Controls_Manager::HIDDEN,
				'default' => '',
			]
		);

		$this->end_controls_section();
	}

	protected function render() {
		do_action('ecobin_action_get_breadcrumb');
	}

}
