<?php
vc_map(array(
    "name" => 'Google Maps V3',
    "base" => "maps",
    "category" => __('Extra Elements', 'consulta'),
	"icon" => "tb-icon-for-vc",
    "description" => __('Google Maps API V3', 'consulta'),
    "params" => array(
        array(
            "type" => "textfield",
            "heading" => __('API Key', 'consulta'),
            "param_name" => "api",
            "value" => '',
            "description" => __('Enter you api key of map, get key from (https://console.developers.google.com)', 'consulta')
        ),
        array(
            "type" => "textfield",
            "heading" => __('Address', 'consulta'),
            "param_name" => "address",
            "value" => 'New York, United States',
            "description" => __('Enter address of Map', 'consulta')
        ),
        array(
            "type" => "textfield",
            "heading" => __('Coordinate', 'consulta'),
            "param_name" => "coordinate",
            "value" => '',
            "description" => __('Enter coordinate of Map, format input (latitude, longitude)', 'consulta')
        ),
        array(
            "type" => "checkbox",
            "heading" => __('Click Show Info window', 'consulta'),
            "param_name" => "infoclick",
            "value" => array(
                __("Yes, please", 'consulta') => true
            ),
            "group" => __("Marker", 'consulta'),
            "description" => __('Click a marker and show info window (Default Show).', 'consulta')
        ),
        array(
            "type" => "textfield",
            "heading" => __('Marker Coordinate', 'consulta'),
            "param_name" => "markercoordinate",
            "value" => '',
            "group" => __("Marker", 'consulta'),
            "description" => __('Enter marker coordinate of Map, format input (latitude, longitude)', 'consulta')
        ),
        array(
            "type" => "textfield",
            "heading" => __('Marker Title', 'consulta'),
            "param_name" => "markertitle",
            "value" => '',
            "group" => __("Marker", 'consulta'),
            "description" => __('Enter Title Info windows for marker', 'consulta')
        ),
        array(
            "type" => "textarea",
            "heading" => __('Marker Description', 'consulta'),
            "param_name" => "markerdesc",
            "value" => '',
            "group" => __("Marker", 'consulta'),
            "description" => __('Enter Description Info windows for marker', 'consulta')
        ),
        array(
            "type" => "attach_image",
            "heading" => __('Marker Icon', 'consulta'),
            "param_name" => "markericon",
            "value" => '',
            "group" => __("Marker", 'consulta'),
            "description" => __('Select image icon for marker', 'consulta')
        ),
        array(
            "type" => "textarea_raw_html",
            "heading" => __('Marker List', 'consulta'),
            "param_name" => "markerlist",
            "value" => '',
            "group" => __("Multiple Marker", 'consulta'),
            "description" => __('[{"coordinate":"41.058846,-73.539423","icon":"","title":"title demo 1","desc":"desc demo 1"},{"coordinate":"40.975699,-73.717636","icon":"","title":"title demo 2","desc":"desc demo 2"},{"coordinate":"41.082606,-73.469718","icon":"","title":"title demo 3","desc":"desc demo 3"}]', 'consulta')
        ),
        array(
            "type" => "textfield",
            "heading" => __('Info Window Max Width', 'consulta'),
            "param_name" => "infowidth",
            "value" => '200',
            "group" => __("Marker", 'consulta'),
            "description" => __('Set max width for info window', 'consulta')
        ),
        array(
            "type" => "dropdown",
            "heading" => __("Map Type", 'consulta'),
            "param_name" => "type",
            "value" => array(
                "ROADMAP" => "ROADMAP",
                "HYBRID" => "HYBRID",
                "SATELLITE" => "SATELLITE",
                "TERRAIN" => "TERRAIN"
            ),
            "description" => __('Select the map type.', 'consulta')
        ),
        array(
            "type" => "dropdown",
            "heading" => __("Style Template", 'consulta'),
            "param_name" => "style",
            "value" => array(
                "Default" => "",
                "Subtle Grayscale" => "Subtle-Grayscale",
                "Shades of Grey" => "Shades-of-Grey",
                "Blue water" => "Blue-water",
                "Pale Dawn" => "Pale-Dawn",
                "Blue Essence" => "Blue-Essence",
                "Apple Maps-esque" => "Apple-Maps-esque",
            ),
            "group" => __("Map Style", 'consulta'),
            "description" => 'Select your heading size for title.'
        ),
        array(
            "type" => "textfield",
            "heading" => __('Zoom', 'consulta'),
            "param_name" => "zoom",
            "value" => '13',
            "description" => __('zoom level of map, default is 13', 'consulta')
        ),
        array(
            "type" => "textfield",
            "heading" => __('Width', 'consulta'),
            "param_name" => "width",
            "value" => 'auto',
            "description" => __('Width of map without pixel, default is auto', 'consulta')
        ),
        array(
            "type" => "textfield",
            "heading" => __('Height', 'consulta'),
            "param_name" => "height",
            "value" => '350px',
            "description" => __('Height of map without pixel, default is 350px', 'consulta')
        ),
        array(
            "type" => "checkbox",
            "heading" => __('Scroll Wheel', 'consulta'),
            "param_name" => "scrollwheel",
            "value" => array(
                __("Yes, please", 'consulta') => true
            ),
            "group" => __("Controls", 'consulta'),
            "description" => __('If false, disables scrollwheel zooming on the map. The scrollwheel is disable by default.', 'consulta')
        ),
        array(
            "type" => "checkbox",
            "heading" => __('Pan Control', 'consulta'),
            "param_name" => "pancontrol",
            "value" => array(
                __("Yes, please", 'consulta') => true
            ),
            "group" => __("Controls", 'consulta'),
            "description" => __('Show or hide Pan control.', 'consulta')
        ),
        array(
            "type" => "checkbox",
            "heading" => __('Zoom Control', 'consulta'),
            "param_name" => "zoomcontrol",
            "value" => array(
                __("Yes, please", 'consulta') => true
            ),
            "group" => __("Controls", 'consulta'),
            "description" => __('Show or hide Zoom Control.', 'consulta')
        ),
        array(
            "type" => "checkbox",
            "heading" => __('Scale Control', 'consulta'),
            "param_name" => "scalecontrol",
            "value" => array(
                __("Yes, please", 'consulta') => true
            ),
            "group" => __("Controls", 'consulta'),
            "description" => __('Show or hide Scale Control.', 'consulta')
        ),
        array(
            "type" => "checkbox",
            "heading" => __('Map Type Control', 'consulta'),
            "param_name" => "maptypecontrol",
            "value" => array(
                __("Yes, please", 'consulta') => true
            ),
            "group" => __("Controls", 'consulta'),
            "description" => __('Show or hide Map Type Control.', 'consulta')
        ),
        array(
            "type" => "checkbox",
            "heading" => __('Street View Control', 'consulta'),
            "param_name" => "streetviewcontrol",
            "value" => array(
                __("Yes, please", 'consulta') => true
            ),
            "group" => __("Controls", 'consulta'),
            "description" => __('Show or hide Street View Control.', 'consulta')
        ),
        array(
            "type" => "checkbox",
            "heading" => __('Over View Map Control', 'consulta'),
            "param_name" => "overviewmapcontrol",
            "value" => array(
                __("Yes, please", 'consulta') => true
            ),
            "group" => __("Controls", 'consulta'),
            "description" => __('Show or hide Over View Map Control.', 'consulta')
        )
    )
));