<?php

if (! defined('WP_DEBUG')) {
	die( 'Direct access forbidden.' );
}

add_action( 'wp_enqueue_scripts', function () {
	wp_enqueue_style( 'parent-style', get_template_directory_uri() . '/style.css' );
});


function childthemename_scripts() {
	wp_enqueue_style('owl-style', get_stylesheet_directory_uri() . '/css/owl.carousel.css');
	wp_enqueue_style('owl-style-theme', get_stylesheet_directory_uri() . '/css/owl.theme.default.min.css');
 wp_enqueue_script(
    'custom-js',
    get_stylesheet_directory_uri() . '/js/custom.js',
    array( 'jquery' )
);
	wp_enqueue_script(
    'owl-js',
    get_stylesheet_directory_uri() . '/js/owl.carousel.js',
    array( 'jquery' )
);
} 
add_action( 'wp_enqueue_scripts', 'childthemename_scripts' );

function custom_shortcode_teams() {
 ob_start();
?>
   
		<div class="teams-area">
		<?php 
										 
										  global $post;
										  $args = array(
											  'post_type' => 'team',
											  'posts_per_page' => -1,
											  'post_status' => 'publish'
										  );
										  $the_query = new WP_Query( $args ); 
		
		?>
		
		<?php if ( $the_query->have_posts() ) : ?>
		<?php while ( $the_query->have_posts() ) : $the_query->the_post(); ?>
		<div class="team-section">
			
					<div class="team-image">
						<div class="short-image">
						<?php echo the_post_thumbnail(); ?>
						<div class="short-desc">
							<p>
								<?php the_excerpt(); ?>
							</p>
						</div>
						</div>
						<h5>
								<?php the_title(); ?>
								
							</h5>
						<h6>
								<?php echo get_field('position'); ?>
								
							</h6>
							<?php the_content(); ?>
							
					</div>
				
		</div>
		<?php endwhile;  ?>
		
		<?php wp_reset_postdata();
		return ob_get_clean();
		?>
		<?php else:  ?>
		  <p><?php _e( 'Sorry, no members matched your criteria.' ); ?></p>
		<?php endif; ?>
	
</div>
<?php }

// Register the shortcode
add_shortcode('teams_shortcode', 'custom_shortcode_teams');


function send_brochure_email() {
    if (!isset($_POST['email']) || !isset($_POST['name'])) {
        wp_send_json_error("Invalid Request");
    }

    $name = sanitize_text_field($_POST['name']);
    $email = sanitize_email($_POST['email']);
    $brochure_link = "http://www.v-enertek.com/wp-content/uploads/2025/02/AboutUS-page-contents.pdf"; // Change this to your actual file link

    // Send email to the user
    $subject = "Your Brochure Download Link";
    $message = "Hi $name, \n\nThank you for downloading our brochure. Here is your download link: \n$brochure_link";
    wp_mail($email, $subject, $message);

    // Notify the admin
    $admin_email = "info@v-enertek.com";
    $admin_subject = "New Brochure Download";
    $admin_message = "User: $name\nEmail: $email\nDownloaded the brochure.";
    wp_mail($admin_email, $admin_subject, $admin_message);

    wp_send_json_success("Email sent successfully.");
}
add_action('wp_ajax_send_brochure_email', 'send_brochure_email');
add_action('wp_ajax_nopriv_send_brochure_email', 'send_brochure_email');


function add_whatsapp_float_icon() {
    ?>
    <style>
        .whatsapp-float {
            position: fixed;
            bottom: 20px;
            right: 20px;
            z-index: 1000;
        }
        .whatsapp-float img {
            width: 60px;
            height: 60px;
        }
    </style>

    <a href="https://wa.me/9043287948" target="_blank" class="whatsapp-float">
        <img src="https://upload.wikimedia.org/wikipedia/commons/6/6b/WhatsApp.svg" alt="WhatsApp">
    </a>
    <?php
}
add_action('wp_footer', 'add_whatsapp_float_icon');

